-- CONSTRAINTS --
-- insert veya update iin kstlamalar (kurallar) getiriyoruz.
use Filmler
go
create table Besteci -- Film tablosu ile 1'e 1 ilikisi olduunu varsayyoruz.
(
	id int not null,
	adi varchar(50),
	soyadi varchar(50),
	film_id int
)
go
insert into Besteci values (1, 'James', 'Horner', 1)
go
select * from Besteci
--------------------------------------------------------------------------------------------------------
-- DEFAULT CONSTRAINT:
go
alter table Besteci
add constraint df_filmid
default 0 for film_id
go
insert into Besteci (id, adi, soyadi) values (2, 'John', 'Williams')
go
select * from Besteci
--------------------------------------------------------------------------------------------------------
-- CHECK CONSTRAINT:
go
insert into Besteci values (3, 'al', 'Alsa', 99)
go
select * from Film
go
select * from Besteci
go
delete from Besteci where adi = 'al' and soyadi = 'Alsa' and film_id = 99
go
select * from Besteci
go
alter table Besteci
add constraint chk_filmid1
check (film_id <= 7)
go
insert into Besteci values (3, 'al', 'Alsa', 99)
go
select * from Besteci
go
insert into Besteci values (3, 'Hans', 'Zimmer', 2)
go
select * from Besteci
go
alter table Besteci add constraint chk_besteciadi
check (LEN(adi) >= 3)
insert into Besteci (id, adi, soyadi) values (4, '', 'Mano') -- LEN(adi) = 0 olaca iin hata verecektir!
insert into Besteci (id, adi, soyadi) values (4, 'Bar', 'Mano')
--------------------------------------------------------------------------------------------------------
go
alter table Besteci
add constraint chk_adi
check (LEN(adi) > 1)
go
insert into Besteci (id, adi, soyadi) values (4, 'B', 'Tyler')
go
select * from Besteci
go
insert into Besteci (id, adi, soyadi) values (4, 'Brian', 'Tyler')
go
select * from Besteci
--------------------------------------------------------------------------------------------------------
go
alter table Besteci
add constraint chk_filmid2
check (film_id >= 5)
-- film_id'si 5'ten kk kaytlar var. bu yzden bu kaytlar varken bu constraint'i ekleyemez.
go
alter table Besteci with nocheck
add constraint chk_filmid3
check (film_id >= 5)
-- with nocheck: Daha nce eklenen kaytlar gzard et.
--------------------------------------------------------------------------------------------------------
-- PRIMARY KEY CONSTRAINT:
go
alter table Besteci
add constraint pk_id
primary key (id)
-- id stunu tablo yaratlrken "not null" olarak belirlenmi olmal!
--------------------------------------------------------------------------------------------------------
-- FOREIGN KEY CONSTRAINT:
go
alter table Besteci with nocheck -- eski kaytlar yoksay (kullanmayabiliriz)
add constraint fk_filmid 
foreign key (film_id) references Film (id)
on delete set null on update cascade
-- on delete cascade: likideki kayd da siler. Kullanmak tehlikeli.
-- on delete set null: Film tablosundan siler, ilikide olduu Besteci tablosunda film_id deerine 
-- null deer atar.
-- on delete set default: Film tablosundan siler, ilikide olduu Besteci tablosunda film_id deerine 
-- default deer atar.
-- "on delete" yerine "on update" de yazabiliriz.
-- Ne "on delete" ne de "on update" yazmadmz zaman kendi otomatik olarak "no action" tanmlyor 
-- ve ilikili tablolar zerinde update ve delete ilemleri yaptrmyor.
--------------------------------------------------------------------------------------------------------
-- Bir tabloda bir stunu unique yapmak?
go
alter table Besteci
add constraint uq_soyadi
unique (soyadi)
--------------------------------------------------------------------------------------------------------
go
drop table Besteci